﻿var findAndReplace = {
    context: $(".v-findAndReplace"),
    datatable: undefined,
    autocomplete: undefined,
    initialize: function () {
        this.autocomplete = $(".h-variablesAutoComplete").a4autocomplete({
            ajaxAction: a4.getSurveyAction("GetVariablesForAutoComplete", "Shared"),
            ajaxParams: { filterPIIs : true },
            select: function (event, data) {
                $(".v-replaceContainer input", findAndReplace.context).val("");
                $(".v-replaceContainer input, .v-replaceContainer .button", findAndReplace.context).prop("disabled", true).addClass("disabled");

                if (data.item) {
                    $(".v-findContainer input, .v-findContainer .button", findAndReplace.context).prop("disabled", false).removeClass("disabled");
                }
                else {
                    $(".v-findContainer input", findAndReplace.context).val("");
                    $(".v-findContainer input, .v-findContainer .button", findAndReplace.context).prop("disabled", true).addClass("disabled");
                }
            }
        });
    },
    bindEvents: function () {
        this.context.on("change", ".v-findValue", function () {
            $(".v-replaceContainer input, .v-replaceContainer .button", findAndReplace.context).prop("disabled", true).addClass("disabled");
            $(".v-replaceContainer input", findAndReplace.context).val("");
        });

        this.context.on("click", ".h-findAll:not(.disabled)", function () {
            findAndReplace.findResponses();
        });

        this.context.on("click", ".h-replaceInSelection:not(.disabled)", function () {
            var selectedRows = findAndReplace.datatable.a4datatable("getSelectedItems");
            if (selectedRows) {
                var respondentIds = _.pluck(selectedRows, "RespondentId");
                if (respondentIds.length > 0) {
                    findAndReplace.replaceResponses(respondentIds);
                }
            }
        });

        this.context.on("click", ".h-replaceAll:not(.disabled)", function () {
            var allRows = findAndReplace.datatable.a4datatable("getRowsData");
            if (allRows) {
                var respondentIds = _.pluck(allRows, "RespondentId");
                if (respondentIds.length > 0) {
                    findAndReplace.replaceResponses(respondentIds);
                }
            }
        });
    },
    findResponses: function () {
        var variable = findAndReplace.autocomplete.a4autocomplete("getValue");

        if (variable) {
            var value = $(".v-findValue", findAndReplace.context).val();
            var windowContext = window.parent.document;
            var filterDefinition = windowContext.getElementById("FilterDefinition").value;
            var parentDataTableParams = JSON.parse(windowContext.getElementById("DataTableParams").value);
            var selectedVariables = windowContext.getElementById("SelectedVariables").value;
            var ajaxParams = { "variable": variable.Value, "value": value, "filter": filterDefinition, "parentDataTableParams": parentDataTableParams, "variables": selectedVariables };

            if (this.datatable) {
                this.datatable.a4datatable("option", "ajaxParams", ajaxParams);
                this.datatable.a4datatable("refresh", true);
            }
            else {
                var displayRowColumn = $("#DisplayRowColumn", this.context).val() == "True";

                var columns = [
                    { "Name": "RespondentId", "Title": resources.CaseId, "Data": "RespondentId" },
                    { "Name": "Mention", "Title": resources.Mention, "Data": "Mention" },
                    { "Name": "Answer", "Title": resources.Value, "Data": "Answer", "EncodeHtml": true }
                ];

                if (displayRowColumn) {
                    columns.splice(1, 0, { "Name": "Matrix", "Title": resources.Row, "Data": "Matrix" });
                }

                this.datatable = $(".h-resultsTable", this.context).a4datatable({
                    style: "compact",                    
                    ajaxAction: a4.getSurveyAction("FindResponses", "Analyze"),
                    ajaxParams: ajaxParams,
                    displaySearchBox: false,
                    allowRowSelection: true,
                    columns: columns,
                    draw: function (event, data) {
                        if (data.totalRecords > 0) {
                            $(".v-replaceContainer input, .v-replaceContainer .button", findAndReplace.context).prop("disabled", false).removeClass("disabled");
                        }
                    }
                });
            }
        }
    },
    replaceResponses: function (respondentIds) {
        var variable = findAndReplace.autocomplete.a4autocomplete("getValue");

        if (variable) {
            var findValue = $(".v-findValue", findAndReplace.context).val() || "";
            var replaceValue = $(".v-replaceValue", findAndReplace.context).val() || "";
            var confirmResources = respondentIds ? confirmFindAndReplaceSelectionResources : confirmFindAndReplaceAllResources;

            modalDialog.showConfirmDialog(confirmResources, function () {
                var windowContext = window.parent.document;
                var filterDefinition = windowContext.getElementById("FilterDefinition").value;
                var parentDataTableParams = JSON.parse(windowContext.getElementById("DataTableParams").value);
                var selectedVariables = windowContext.getElementById("SelectedVariables").value;
                a4.callServerMethod(a4.getSurveyAction("UpdateFoundResponses", "Analyze"), { variable: variable.Value, findValue: findValue, replaceValue: replaceValue, filter: filterDefinition, "parentDataTableParams": parentDataTableParams, "variables": selectedVariables, respondentIds: respondentIds },
                function (result) {
                    a4.showSuccessMessage(resources.UpdatedResponsesMessage.replace(/{count}/g, result.updated), 2000);
                    findAndReplace.datatable.a4datatable("refresh");
                });
            }, 250, 500, false, { "variable": variable.Value, "findValue": findValue ? findValue : resources.Empty, "replaceValue": replaceValue ? replaceValue : resources.Empty, "count": respondentIds ? respondentIds.length : 0 });
        }
    }
}

$(document).ready(function () {
    if (findAndReplace.context.length > 0) {
        findAndReplace.initialize();
        findAndReplace.bindEvents();
    }
});